/*!
 * Float Labels
 *
 * @version: 3.3.0
 * @author: Paul Ryley (http://geminilabs.io)
 * @url: https://geminilabs.github.io/float-labels.js
 * @license: MIT
 */
!function(t,e,i){"use strict";var s=function(t,i){this.el=this.isString(t)?e.querySelectorAll(t):[t],this.config=[],this.options=i,this.selectors=[],this.init(),this.destroy=function(){this.loop(function(t){t.removeEventListener("reset",this.events.reset),this.removeClasses(t)},function(t){this.reset(t)})},this.rebuild=function(){this.loop(null,function(t){this.floatLabel(t,!0)})}};s.prototype={defaults:{customEvent:null,customLabel:null,customPlaceholder:null,exclude:".no-label",inputRegex:/email|number|password|search|tel|text|url/,prefix:"fl-",prioritize:"label",requiredClass:"required",style:0,transform:"input,select,textarea"},init:function(){this.initEvents(),this.loop(function(t,e){var i=this.config[e].style;t.addEventListener("reset",this.events.reset),t.classList.add(this.prefixed("form")),i&&t.classList.add(this.prefixed("style-"+i))},function(t){this.floatLabel(t)})},initEvents:function(){this.events={blur:this.onBlur.bind(this),change:this.onInput.bind(this),focus:this.onFocus.bind(this),input:this.onInput.bind(this),reset:this.onReset.bind(this)}},build:function(t){var e=this.getLabel(t);e&&(t.classList.add(this.prefixed(t.tagName.toLowerCase())),this.setLabel(e,t),this.setPlaceholder(e,t),this.wrapLabel(e,t),this.handleEvents(t,"add"),"function"==typeof this.config[this.current].customEvent&&this.config[this.current].customEvent.call(this,t))},createEl:function(t,i){var s="string"==typeof t?e.createElement(t):t;i=i||{};for(var r in i)i.hasOwnProperty(r)&&s.setAttribute(r,i[r]);return s},extend:function(){var t=[].slice.call(arguments),e=t[0],i=t.slice(1);return Object.keys(i).forEach(function(t){for(var s in i[t])i[t].hasOwnProperty(s)&&(e[s]=i[t][s])}),e},floatLabel:function(t,e){if(t.getAttribute("id")&&("INPUT"!==t.tagName||this.config[this.current].inputRegex.test(t.getAttribute("type")))){if(this.hasParent(t)){if(!0!==e)return;this.reset(t)}this.build(t)}},getLabel:function(t){var e='label[for="'+t.getAttribute("id")+'"]',i=this.el[this.current].querySelectorAll(e);return i.length>1&&(i=t.parentNode.querySelectorAll(e)),1===i.length&&i[0]},getLabelText:function(t,e){var i=t.textContent.replace(/[*:]/g,"").trim(),s=e.getAttribute("placeholder");return(!i||i&&s&&"placeholder"===this.config[this.current].prioritize)&&(i=s),i},handleEvents:function(t,e){var i=this.events;["blur","input","focus"].forEach(function(s){"file"===t.type&&"input"===s&&(s="change"),t[e+"EventListener"](s,i[s])})},hasParent:function(t){return t.parentNode.classList.contains(this.prefixed("wrap"))},isString:function(t){return"[object String]"===Object.prototype.toString.call(t)},loop:function(t,e){for(var i=0;i<this.el.length;++i){if(void 0===this.selectors[i]){var s=this.extend({},this.defaults,this.options,this.el[i].getAttribute("data-options")),r=":not("+s.exclude.split(/[\s,]+/).join("):not(")+")";this.selectors[i]=s.transform.replace(/,/g,r+",")+r,this.config[i]=s}var n=this.el[i].querySelectorAll(this.selectors[i]);this.current=i,"function"==typeof t&&t.call(this,this.el[i],i);for(var l=0;l<n.length;++l)"function"==typeof e&&e.call(this,n[l],i)}},onBlur:function(t){t.target.parentNode.classList.remove(this.prefixed("has-focus"))},onInput:function(t){var e=t.target.value.length?"add":"remove";t.target.parentNode.classList[e](this.prefixed("is-active"))},onFocus:function(t){t.target.parentNode.classList.add(this.prefixed("has-focus"))},onReset:function(){for(var t=this.el[this.current].querySelectorAll(this.selectors[this.current]),e=0;e<t.length;++e)t[e].parentNode.classList.remove(this.prefixed("is-active"))},prefixed:function(t){return this.config[this.current].prefix+t},removeClasses:function(t){var e=this.config[this.current].prefix,i=t.className.split(" ").filter(function(t){return 0!==t.lastIndexOf(e,0)});t.className=i.join(" ").trim()},reset:function(t){var i=t.parentNode;if(this.hasParent(t)){for(var s=e.createDocumentFragment();i.firstElementChild;){var r=i.firstElementChild;this.removeClasses(r),s.appendChild(r)}i.parentNode.replaceChild(s,i),this.resetPlaceholder(t),this.handleEvents(t,"remove")}},resetPlaceholder:function(t){var e=t.getAttribute("data-placeholder");null!==e&&(t.removeAttribute("data-placeholder"),t.setAttribute("placeholder",e))},setLabel:function(t,e){t.classList.add(this.prefixed("label")),t.textContent=this.getLabelText(t,e),"function"==typeof this.config[this.current].customLabel&&(t.textContent=this.config[this.current].customLabel.call(this,t,e))},setPlaceholder:function(t,e){var i=e.getAttribute("placeholder");"label"!==this.config[this.current].prioritize&&i||(i&&e.setAttribute("data-placeholder",i),i=this.getLabelText(t,e)),"function"==typeof this.config[this.current].customPlaceholder&&(i=this.config[this.current].customPlaceholder.call(this,i,e,t)),"SELECT"===e.tagName?this.setSelectPlaceholder(e,i):e.setAttribute("placeholder",i)},setSelectPlaceholder:function(t,e){var i=t.firstElementChild;i.hasAttribute("value")&&i.value?t.insertBefore(new Option(e,"",!0,!0),i):i.setAttribute("value",""),""===i.textContent&&(i.textContent=e)},wrapLabel:function(t,e){var i=this.createEl("div",{class:this.prefixed("wrap")+" "+this.prefixed("wrap-"+e.tagName.toLowerCase())});void 0!==e.value&&e.value.length&&i.classList.add(this.prefixed("is-active")),(null!==e.getAttribute("required")||e.classList.contains(this.config[this.current].requiredClass))&&i.classList.add(this.prefixed("is-required")),e.parentNode.insertBefore(i,e),i.appendChild(t),i.appendChild(e)}},t.FloatLabels=s}(window,document);

var floatlabels = new FloatLabels( '.fl-labels', {prioritize: 'placeholder'});
